<!DOCTYPE html>
<html lang="zh-CN">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta charset="utf-8">
<meta name="title" content="播放器">
<meta name="apple-touch-fullscreen" content="YES">
<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="format-detection" content="telephone=no">

<title>播放器</title>
<style>
body {
  margin: 0;
  padding: 0;
  background: #000;
  overflow: hidden;
}

/* 外层容器：自动自适应比例 */
.web_size {
  position: relative;
  width: 100%;
  height: 100vh;          /* ✅ 浏览器视窗高度 */
  background: #000;
  overflow: hidden;
}

/* ✅ video.js 播放器自适应比例 */
.video-js {
  width: 100% !important;
  height: 100% !important;
  max-width: 100%;
  max-height: 100%;
  background-color: #000;
  object-fit: cover !important;
}

/* ✅ 封面图正常铺满 */
.vjs-poster {
  background-size: cover !important;
  background-position: center center !important;
  background-repeat: no-repeat !important;
}


.vjs-poster {
  background-size: cover !important;
  background-position: center center !important;
  background-repeat: no-repeat !important;
}

/* ✅ 播放按钮居中 */
.video-js .vjs-big-play-button {
  position: absolute !important;
  top: 50% !important;
  left: 50% !important;
  transform: translate(-50%, -50%) !important;
  margin: 0 !important;
  z-index: 10 !important;
}

/* ✅ 去掉字幕按钮 */
.video-js .vjs-control.vjs-subs-caps-button,
.video-js .vjs-subs-caps-button,
.video-js .vjs-texttrack-settings {
  display: none !important;
}

/* ✅ 响应式适配：在小屏上保持比例 */
@media (max-width: 768px) {
  .web_size {
    height: auto;
    aspect-ratio: 16/9; /* 默认视频比例16:9 */
  }
}
/* ✅ 底部控制栏磨砂（不覆盖进度条） */
.vjs-control-bar {
  background: none !important;  /* 去掉整体磨砂 */
  border-top: none !important;
}

/* ✅ 单独给按钮区添加磨砂背景 */
.vjs-control-bar::after {
  content: "";
  position: absolute;
  bottom: 0;
  left: 0;
  width: 100%;
  height: 36px; /* ✅ 与按钮高度一致 */
  background: rgba(0, 0, 0, 0.35);
  backdrop-filter: blur(6px);
  border-top: 1px solid rgba(255, 255, 255, 0.1);
  pointer-events: none; /* 不阻止点击 */
  z-index: 0;
}

/* ✅ 确保按钮在磨砂层上方 */
.vjs-control-bar .vjs-control {
  position: relative;
  z-index: 1;
}

/* ✅ 进度条保持独立 */
.vjs-progress-control {
  z-index: 2;
  margin-bottom: 4px !important; /* 与磨砂层保持微距 */
}
/* ✅ 隐藏音量滑条，只保留音量图标 */
.vjs-volume-panel.vjs-volume-panel-horizontal .vjs-volume-control {
  display: none !important;
}

/* ✅ 图标大小 & 点击反馈 */
.vjs-mute-control {
  cursor: pointer !important;
  transition: transform 0.2s ease;
}
.vjs-mute-control:hover {
  transform: scale(1.15);
}

/* ✅ 避免空滑条占位 */
.vjs-volume-panel {
  width: 40px !important;
  min-width: 40px !important;
}


</style>

<body>
<?php
// 引入公共安全过滤函数
include('../../../Php/Public/Helper.php');

// 获取播放地址与封面参数
$vPath  = safeRequest($_GET['Play']);
$poster = safeRequest($_GET['Cover']);
?>
<div class="web_size">
    <!-- ✅ 加上封面 poster 属性 -->
    <video 
        id="myVideo" 
        class="video-js vjs-default-skin"
        controls
        preload="auto"
        poster="<?php echo $poster; ?>">
    </video>

    <!-- 样式与脚本保持原样 -->
    <link rel="stylesheet" type="text/css" href="video.min.css?v=3">
    <script type="text/javascript" src="video.min.js?v=1" charset="utf-8"></script>
    <script type="text/javascript" src="video-conrtib-ads.js?v=1" charset="utf-8"></script>
    <script type="text/javascript" src="myVideo.js?v=6" charset="utf-8"></script>

    <script type="text/javascript">
        // 播放器参数
        var vPath = '<?php echo $vPath; ?>';
        var logo = '';
        // 保持你原有的初始化逻辑
        var myVideo = initVideo({
            id: 'myVideo',
            url: vPath,
            ad: {
                pre: {
                    url: '',
                    link: '',
                },
            },
        });
    </script>
</div>
</body>
</html>
